<?php
defined('BASEPATH') or exit('No direct script access allowed');

class tambah_ruta extends CI_Controller
{

    public function __construct()
    {
        setlocale(LC_ALL, 'id_ID.utf8');
        parent::__construct();
        $this->load->library('form_validation');
        $this->load->model('Tambah_ruta_model', 'ruta', true);

        is_login();
        // is_admin();
    }
    public function index()
    {
        $data['pengguna'] = $this->db->get_where('dc_pengguna', ['email' => $this->session->userdata('email')])->row_array();
        // var_dump($data['pengguna']);
        $this->template->render_page('tambah_ruta', $data);
    }
    public function blok123($id)
    {
        $data['blok1'] = $this->ruta->getrutabyid($id);
        $data['pengguna'] = $this->db->get_where('dc_pengguna', ['email' => $this->session->userdata('email')])->row_array();

        // var_dump($data['blok1']);
        $this->template->render_page('tambah_ruta', $data);
    }
    public function blok45($id)
    {
        $data['blok1'] = $this->ruta->getrutabyid($id);
        $data['pengguna'] = $this->db->get_where('dc_pengguna', ['email' => $this->session->userdata('email')])->row_array();

        // var_dump($data['blok1']);
        $this->template->render_page('tambah_ruta1', $data);
    }
    public function blok67($id)
    {
        $data['pengguna'] = $this->db->get_where('dc_pengguna', ['email' => $this->session->userdata('email')])->row_array();

        $data['blok1'] = $this->ruta->getrutabyid($id);
        $data['lahan'] = $this->ruta->get_lahanbyid($id);
        $data['countlahan'] = $this->ruta->countlahan($id);
        // var_dump($data['countlahan']);
        $this->template->render_page('tambah_ruta2', $data);
    }

    public function blok1()
    {
        // $data['user'] = $this->db->get_where('m_pegawai', ['username' => $this->session->userdata('username')])->row_array();
        // $data['title'] = 'SIMAS | Dashboard';
        // $data['countmitra'] = $this->user_model->countmitra();
        // $data['kegiatan'] = $this->user_model->get_kegiatan();
        $data['pengguna'] = $this->db->get_where('dc_pengguna', ['email' => $this->session->userdata('email')])->row_array();

        $this->form_validation->set_rules('provinsi', 'Provinsi', 'required|trim', [
            'required'        => "Nama Provinsi harus diisi",
        ]);
        $this->form_validation->set_rules('kabupaten', 'Kabupaten', 'required|trim', [
            'required'        => "Nama Kabupaten harus diisi",
        ]);
        $this->form_validation->set_rules('kecamatan', 'kecamatan', 'required|trim', [
            'required'        => "Nama kecamatan harus diisi",
        ]);
        $this->form_validation->set_rules('desa', 'desa', 'required|trim', [
            'required'        => "Nama desa harus diisi",
        ]);
        $this->form_validation->set_rules('alamat', 'alamat', 'required|trim', [
            'required'        => "Nama alamat harus diisi",
        ]);
        $this->form_validation->set_rules('nokk', 'Nomor KK', 'required|trim|exact_length[16]', [
            'required'        => "Nomor Kartu Keluarga harus diisi",
            'exact_length' => "Panjang Nomor Kartu Keluarga harus 16 digit"
        ]);
        $this->form_validation->set_rules('namaKK', 'Nama Kepala Keluarga', 'required|trim', [
            'required'        => "Nama Kepala Keluarga harus diisi",
        ]);
        $this->form_validation->set_rules('jmlagt', 'Jumlah Anggota Keluarga', 'required|trim', [
            'required'        => "Jumlah Anggota Keluarga harus diisi",
        ]);
        $this->form_validation->set_rules('norumah', 'Nomor Bangunan', 'required|trim', [
            'required'        => "Nomor Bangunan Rumah harus diisi"
        ]);
        $nokk = $this->input->post('nokk', TRUE);
        if ($this->form_validation->run() == false) {
            $this->session->set_flashdata("informasi", "<script>swal('Gagal!','Mohon isi dengan lengkap','error');</script>");
            $this->template->render_page('tambah_ruta', $data);
        } else {
            $this->ruta->tambahblok1();
            $this->session->set_flashdata("informasi", "<script>swal('Berhasil!','Berhasil Menambahkan ','success');</script>");

            $data['blok1'] = $this->ruta->getrutablok1($nokk);
            // var_dump($data['blok1']);
            $this->template->render_page('tambah_ruta', $data);
        }

        // var_dump($data['user']);
    }
    public function bok1($idz)
    {
        $id = $this->input->post('id', TRUE);
        $buah = $this->input->post('buah', TRUE);
        $provinsi = $this->input->post('provinsi', TRUE);
        $kabupaten = $this->input->post('kabupaten', TRUE);
        $kecamatan = $this->input->post('kecamatan', TRUE);
        $desa = $this->input->post('desa', TRUE);
        $alamat = $this->input->post('alamat', TRUE);
        $nokk = $this->input->post('nokk', TRUE);
        $namaKK = $this->input->post('namaKK', TRUE);
        $jmlagt = $this->input->post('jmlagt', TRUE);
        $norumah = $this->input->post('norumah', TRUE);

        $edit = $this->ruta->ubahblok1($id, $provinsi, $kabupaten, $kecamatan, $desa, $alamat, $nokk, $namaKK, $jmlagt, $norumah);
        $data['blok1'] = $this->ruta->getrutabyid($idz);
        $data['pengguna'] = $this->db->get_where('dc_pengguna', ['email' => $this->session->userdata('email')])->row_array();
        // var_dump($data['blok1'][0]->perahu);
        if ($edit) {
            $this->session->set_flashdata("informasi", "<script>swal('Berhasil!','Berhasil Mengganti Data ','success');</script>");
            // redirect('tambah_ruta1');
            $this->template->render_page('tambah_ruta', $data);
        } else {
            $this->session->set_flashdata("informasi", "<script>swal('Gagal!','Tidak Berhasil Mengganti Data  ','error');</script>");
            $this->template->render_page('tambah_ruta', $data);
        }
    }
    public function blok2($idz)
    {
        $this->form_validation->set_rules('tglcacah', 'tglcacah', 'required|trim', [
            'required'        => "Tanggal Pencacahan harus diisi",
        ]);
        $this->form_validation->set_rules('namapencacah', 'namapencacah', 'required|trim', [
            'required'        => "Nama Pencacah harus diisi",
        ]);
        $this->form_validation->set_rules('tglperiksa', 'tglperiksa', 'required|trim', [
            'required'        => "Tanggal Periksa harus diisi",
        ]);
        $this->form_validation->set_rules('namaperiksa', 'namaperiksa', 'required|trim', [
            'required'        => "Nama Pemeriksa harus diisi",
        ]);
        $this->form_validation->set_rules('hasil', 'hasil', 'required|trim', [
            'required'        => "Hasil Pencacahan harus diisi",
        ]);
        $id = $this->input->post('id', TRUE);
        $tglcacah = $this->input->post('tglcacah', TRUE);
        $tglperiksa = $this->input->post('tglperiksa', TRUE);
        $namapencacah = $this->input->post('namapencacah', TRUE);
        $namaperiksa = $this->input->post('namaperiksa', TRUE);
        $hasil = $this->input->post('hasil', TRUE);
        $edit = $this->ruta->ubahblok2($id, $tglcacah, $tglperiksa, $namapencacah, $namaperiksa, $hasil);
        $data['blok1'] = $this->ruta->getrutabyid($idz);
        $data['pengguna'] = $this->db->get_where('dc_pengguna', ['email' => $this->session->userdata('email')])->row_array();
        if ($this->form_validation->run() == false) {
            $this->session->set_flashdata("informasi", "<script>swal('Gagal!','Mohon isi dengan lengkap','error');</script>");
            $this->template->render_page('tambah_ruta', $data);
        } else {
            if ($edit) {
                $this->session->set_flashdata("informasi", "<script>swal('Berhasil!','Berhasil Menambahkan Data ','success');</script>");
                $this->template->render_page('tambah_ruta', $data);
                // redirect('tambah_ruta1');

            }
        }
    }
    public function blok3($idz)
    {
        $this->form_validation->set_rules('status', 'Status Penguasaan Bangunan Tempat Tinggal', 'required|trim', [
            'required'        => "Status Penguasaan Bangunan Tempat Tinggal harus diisi",
        ]);
        $this->form_validation->set_rules('luas', 'Luas Lantai', 'required|trim', [
            'required'        => "Luas Lantai harus diisi",
        ]);
        $this->form_validation->set_rules('jenis', 'Jenis Lantai terluas', 'required|trim|less_than_equal_to[10]|greater_than[0]', [
            'required'        => "Jenis Lantai terluas harus diisi",
            'less_than_equal_to' => "Input melebihi 10 digit",
            'greater_than' => "Input harus melebihi dari 0"
        ]);
        $this->form_validation->set_rules('jenisdinding', 'Jenis Dinding Terluas', 'required|trim', [
            'required'        => "Jenis Dinding Terluas harus diisi",
        ]);
        $this->form_validation->set_rules('jenisatap', 'Jenis Atap Terluas', 'required|trim|less_than_equal_to[10]|greater_than[0]', [
            'required'        => "Jenis Atap Terluas harus diisi",
            'less_than_equal_to' => "Input melebihi 10 digit",
            'greater_than' => "Input harus melebihi dari 0"
        ]);
        $this->form_validation->set_rules('jumkamar', 'Jumlah Kamar Tidur', 'required|trim', [
            'required'        => "Jumlah Kamar Tidur harus diisi",
        ]);

        $this->form_validation->set_rules('sumberair', 'Sumber Air Minum', 'required|trim|less_than_equal_to[12]|greater_than[0]', [
            'required'        => "Sumber Air Minum harus diisi",
            'less_than_equal_to' => "Input melebihi 12 digit",
            'greater_than' => "Input harus melebihi dari 0"
        ]);
        $this->form_validation->set_rules('caraair', 'Cara Memperoleh Air Minum', 'required|trim', [
            'required'        => "Cara Memperoleh Air harus diisi",
        ]);
        $this->form_validation->set_rules('sumberpen', 'Sumber Penerangan Utama', 'required|trim', [
            'required'        => "Sumber Penerangan Utama diisi",
        ]);
        // $this->form_validation->set_rules('bahan', 'Bahan bakar/energi untuk memasak', 'required|trim', [
        //     'required'        => "Bahan bakar/energi untuk memasak diisi",
        // ]);
        // $this->form_validation->set_rules('pengguna', 'Penggunaan fasilitas tempat buang air besar', 'required|trim', [
        //     'required'        => "Penggunaan fasilitas tempat buang air besar diisi",
        // ]);

        // $this->form_validation->set_rules('tempatpembuagan', 'Tempat Pembuangan Akhir Tinja', 'required|trim', [
        //     'required'        => "Tempat Pembuangan Akhir Tinja harus diisi"
        // ]);
        $data['pengguna'] = $this->db->get_where('dc_pengguna', ['email' => $this->session->userdata('email')])->row_array();
        $data['blok1'] = $this->ruta->getrutabyid($idz);
        if ($this->form_validation->run() == false) {
            $this->session->set_flashdata("informasi", "<script>swal('Gagal!','Mohon isi dengan lengkap','error');</script>");
            $this->template->render_page('tambah_ruta', $data);
        } else {
            $id = $this->input->post('id', TRUE);
            $status = $this->input->post('status', TRUE);
            $status2 = $this->input->post('status2', TRUE);
            $luas = $this->input->post('luas', TRUE);
            $jenis = $this->input->post('jenis', TRUE);
            $jenisdinding = $this->input->post('jenisdinding', TRUE);
            $kondisidinding = $this->input->post('kondisidinding', TRUE);
            $jenisatap = $this->input->post('jenisatap', TRUE);
            $kondisiatap = $this->input->post('kondisiatap', TRUE);
            $jumkamar = $this->input->post('jumkamar', TRUE);
            $sumberair = $this->input->post('sumberair', TRUE);
            $caraair = $this->input->post('caraair', TRUE);
            $sumberpen = $this->input->post('sumberpen', TRUE);
            $daya = $this->input->post('daya', TRUE);
            $bahan = $this->input->post('bahan', TRUE);
            $pengguna = $this->input->post('pengguna', TRUE);
            $jeniskloset = $this->input->post('jeniskloset', TRUE);
            $tempatpembuangan = $this->input->post('tempatpembuangan', TRUE);
            $edit = $this->ruta->ubahblok3($id, $status, $status2, $luas, $jenis, $jenisdinding, $kondisidinding, $jenisatap, $kondisiatap, $jumkamar, $sumberair, $caraair, $sumberpen, $daya, $bahan, $pengguna, $jeniskloset, $tempatpembuangan);

            if ($edit) {
                $data['blok1'] = $this->ruta->getrutabyid($idz);
                // $data['blok1'] = $this->ruta->getrutablok1();
                // var_dump($data['blok1']);
                $this->template->render_page('tambah_ruta', $data);
                $this->session->set_flashdata("informasi", "<script>swal('Berhasil!','Berhasil Mengganti Data ','success');</script>");
            }
            // $this->user_model->tambah_kegiatan();
            // // $this->user_model->tambah_kegiatan2();
            // $this->session->set_flashdata("informasi", "<script>swal('Berhasil!','Berhasil Menambah Kelola Kegiatan','success');</script>");
            // redirect('kelola_kegiatan');
        }

        // var_dump($data['user']);
    }
    public function blok4($idz)
    {
        $this->form_validation->set_rules('pekerjaan', 'Pekerjaan yang Menghasilkan Pendapatan Terbesar', 'required|trim', [
            'required'        => "Pekerjaan yang Menghasilkan Pendapatan Terbesar harus diisi",
        ]);
        $this->form_validation->set_rules('pendapatan', 'Pendapatan Seluruh Anggota Keluarga Per Bulan', 'required|trim', [
            'required'        => "Pendapatan Seluruh Anggota Keluarga Per Bulan harus diisi",
        ]);
        $id = $this->input->post('id', TRUE);
        $pekerjaan = $this->input->post('pekerjaan', TRUE);
        $pendapatan = $this->input->post('pendapatan', TRUE);
        $edit = $this->ruta->ubahblok4($id, $pekerjaan, $pendapatan);
        $data['blok1'] = $this->ruta->getrutabyid($idz);
        $data['pengguna'] = $this->db->get_where('dc_pengguna', ['email' => $this->session->userdata('email')])->row_array();

        if ($this->form_validation->run() == false) {
            $this->session->set_flashdata("informasi", "<script>swal('Gagal!','Mohon isi dengan lengkap','error');</script>");
            $this->template->render_page('tambah_ruta1', $data);
        } else {
            if ($edit) {
                $data['blok1'] = $this->ruta->getrutabyid($idz);
                // var_dump($data['blok1']);
                $this->template->render_page('tambah_ruta1', $data);
                $this->session->set_flashdata("informasi", "<script>swal('Berhasil!','Berhasil Mengganti Data ','success');</script>");
            }
            // $this->user_model->tambah_kegiatan();
            // // $this->user_model->tambah_kegiatan2();
            // $this->session->set_flashdata("informasi", "<script>swal('Berhasil!','Berhasil Menambah Kelola Kegiatan','success');</script>");
            // redirect('kelola_kegiatan');
        }
    }
    public function blok5($idz)
    {
        $this->form_validation->set_rules('tabung', 'Tabung', 'required|trim', [
            'required'        => "Tabung harus diisi",
        ]);
        $id = $this->input->post('id', TRUE);
        $nokk = $this->input->post('nokk', TRUE);
        $tabung = $this->input->post('tabung', TRUE);
        $komp = $this->input->post('komp', TRUE);
        $lemari = $this->input->post('lemari', TRUE);
        $sepeda = $this->input->post('sepeda', TRUE);
        $ac = $this->input->post('ac', TRUE);
        $spdmtr = $this->input->post('spdmtr', TRUE);
        $pmnsair = $this->input->post('pmnsair', TRUE);
        $mbl = $this->input->post('mbl', TRUE);
        $tlpnrmh = $this->input->post('tlpnrmh', TRUE);
        $perahu = $this->input->post('perahu', TRUE);
        $telv = $this->input->post('telv', TRUE);
        $mtrtempl = $this->input->post('mtrtempl', TRUE);
        $emas = $this->input->post('emas', TRUE);
        $prhmtr = $this->input->post('prhmtr', TRUE);
        $kapal = $this->input->post('kapal', TRUE);
        $nohp = $this->input->post('nohp', TRUE);
        $tv = $this->input->post('tv', TRUE);
        $lhn = $this->input->post('lhn', TRUE);
        $buah = $this->input->post('buah', TRUE);
        $rmhtmpt = $this->input->post('rmhtmpt', TRUE);
        $sapi = $this->input->post('sapi', TRUE);
        $babi = $this->input->post('babi', TRUE);
        $kerbau = $this->input->post('kerbau', TRUE);
        $kuda = $this->input->post('kuda', TRUE);
        $kambing = $this->input->post('kambing', TRUE);
        $edit = $this->ruta->ubahblok5($id, $nokk,  $tabung, $komp, $lemari, $sepeda, $ac, $spdmtr, $pmnsair, $mbl, $tlpnrmh, $perahu, $telv, $mtrtempl, $emas, $prhmtr, $kapal, $nohp, $tv, $lhn, $buah, $rmhtmpt, $sapi, $babi, $kerbau, $kuda, $kambing);
        $data['blok1'] = $this->ruta->getrutabyid($idz);
        $data['pengguna'] = $this->db->get_where('dc_pengguna', ['email' => $this->session->userdata('email')])->row_array();

        if ($this->form_validation->run() == false) {
            $this->session->set_flashdata("informasi", "<script>swal('Gagal!','Mohon isi dengan lengkap','error');</script>");
            $this->template->render_page('tambah_ruta1', $data);
        } else {
            if ($edit) {
                $data['blok1'] = $this->ruta->getrutabyid($idz);
                // var_dump($data['blok1']);
                $this->template->render_page('tambah_ruta1', $data);
                $this->session->set_flashdata("informasi", "<script>swal('Berhasil!','Berhasil Mengganti Data ','success');</script>");
            }
            // $this->user_model->tambah_kegiatan();
            // // $this->user_model->tambah_kegiatan2();
            // $this->session->set_flashdata("informasi", "<script>swal('Berhasil!','Berhasil Menambah Kelola Kegiatan','success');</script>");
            // redirect('kelola_kegiatan');
        }
    }
    public function blok6($idz)
    {
        $this->form_validation->set_rules('namalhn', 'namalhn', 'required|trim', [
            'required'        => "Nama Lahan harus diisi",
        ]);
        $this->form_validation->set_rules('hub', 'hub', 'required|trim', [
            'required'        => "Jenis Lahan harus diisi",
        ]);
        $this->form_validation->set_rules('sppt', 'sppt', 'required|trim', [
            'required'        => "Keberadaan SPPT harus diisi",
        ]);
        $id = $this->input->post('id', TRUE);
        $nokk = $this->input->post('nokk', TRUE);
        $id_kk_fgn = $this->input->post('id_kk_fgn', TRUE);
        $namalhn = $this->input->post('namalhn', TRUE);
        $hub = $this->input->post('hub', TRUE);
        $sppt = $this->input->post('sppt', TRUE);
        $nopajak = $this->input->post('nopajak', TRUE);
        $llahan = $this->input->post('llahan', TRUE);
        $haksertif = $this->input->post('haksertif', TRUE);
        $nmhak = $this->input->post('nmhak', TRUE);
        $edit = $this->ruta->ubahblok6($id, $nokk,  $namalhn, $hub, $sppt, $nopajak, $llahan, $haksertif, $nmhak);
        $data['blok1'] = $this->ruta->getrutabyid($idz);
        $data['lahan'] = $this->ruta->get_lahanbyid($idz);
        $data['countlahan'] = $this->ruta->countlahan($idz);
        $data['pengguna'] = $this->db->get_where('dc_pengguna', ['email' => $this->session->userdata('email')])->row_array();

        if ($this->form_validation->run() == false) {
            // $data['lahan1'] = $this->ruta->get_lahanbyid($idut);
            // $data['countlahan1'] = $this->ruta->countlahan($idut);
            $this->session->set_flashdata("informasi", "<script>swal('Gagal!','Mohon isi dengan lengkap','error');</script>");
            $this->template->render_page('tambah_ruta2', $data);
            // var_dump($idut);
        } else {
            if ($edit) {
                $data['countlahan'] = $this->ruta->countlahan($id_kk_fgn);
                $data['blok1'] = $this->ruta->getrutabyid($idz);
                $data['lahan'] = $this->ruta->get_lahanbyid($id_kk_fgn);
                // var_dump($data['blok1']);
                $this->session->set_flashdata("informasi", "<script>swal('Berhasil!','Berhasil Mengganti Data ','success');</script>");
                $this->template->render_page('tambah_ruta2', $data);
            }
            // $this->user_model->tambah_kegiatan();
            // // $this->user_model->tambah_kegiatan2();
            // $this->session->set_flashdata("informasi", "<script>swal('Berhasil!','Berhasil Menambah Kelola Kegiatan','success');</script>");
            // redirect('kelola_kegiatan');
        }
    }
    public function blok7($idz)
    {
        $this->form_validation->set_rules('nama', 'nama', 'required|trim', [
            'required'        => "Nama Anggota Rumah Tangga harus diisi",
        ]);
        $this->form_validation->set_rules('nik', 'nik', 'required|trim', [
            'required'        => "Jenis Lahan harus diisi",
        ]);
        $id = $this->input->post('id', TRUE);
        // $nokk = $this->input->post('nokk', TRUE);
        $nokk = $this->input->post('nokk', TRUE);
        $nama = $this->input->post('nama', TRUE);
        $nik = $this->input->post('nik', TRUE);
        $hubkel = $this->input->post('hubkel', TRUE);
        $jk = $this->input->post('jk', TRUE);
        $umur = $this->input->post('umur', TRUE);
        $sts = $this->input->post('sts', TRUE);
        $pemilik = $this->input->post('pemilik', TRUE);
        $kk = $this->input->post('kk', TRUE);
        $ki = $this->input->post('ki', TRUE);
        $hamil = $this->input->post('hamil', TRUE);
        $kb = $this->input->post('kb', TRUE);
        $jc = $this->input->post('jc', TRUE);
        $kronis = $this->input->post('kronis', TRUE);
        $goldar = $this->input->post('goldar', TRUE);
        $sekolah = $this->input->post('sekolah', TRUE);
        $pend = $this->input->post('pend', TRUE);
        $kelas = $this->input->post('kelas', TRUE);
        $ijazah = $this->input->post('ijazah', TRUE);
        $pensi = $this->input->post('pensi', TRUE);
        $kerja = $this->input->post('kerja', TRUE);
        $lapangan = $this->input->post('lapangan', TRUE);
        $statkerja = $this->input->post('statkerja', TRUE);
        $jumpkerja = $this->input->post('jumpkerja', TRUE);
        $tmptlokasi = $this->input->post('tmptlokasi', TRUE);
        $omsetusaha = $this->input->post('omsetusaha', TRUE);
        $agm = $this->input->post('agm', TRUE);
        $suku = $this->input->post('suku', TRUE);
        $dmsl = $this->input->post('dmsl', TRUE);
        $bansos = $this->input->post('bansos', TRUE);
        $edit = $this->ruta->ubahblok7($id, $nokk, $nama, $nik, $hubkel, $jk, $umur, $sts, $pemilik, $kk, $ki, $hamil, $kb, $jc, $kronis, $goldar, $sekolah, $pend, $kelas, $ijazah, $pensi, $kerja, $lapangan, $statkerja, $jumpkerja, $tmptlokasi, $omsetusaha, $agm, $suku, $dmsl, $bansos);
        $data['blok1'] = $this->ruta->getrutabyid($idz);
        $data['agt'] = $this->ruta->get_agt($idz);
        $data['countagt'] = $this->ruta->countart($idz);
        $data['pengguna'] = $this->db->get_where('dc_pengguna', ['email' => $this->session->userdata('email')])->row_array();

        // var_dump($data['agt']);
        if ($this->form_validation->run() == false) {
            // $data['lahan1'] = $this->ruta->get_lahanbyid($idut);
            // $data['countlahan1'] = $this->ruta->countlahan($idut);
            $this->session->set_flashdata("informasi", "<script>swal('Gagal!','Mohon isi dengan lengkap','error');</script>");
            $this->template->render_page('tambah_ruta3', $data);
            // var_dump($idut);
        } else {
            if ($edit) {
                $data['blok1'] = $this->ruta->getrutabyid($idz);
                $data['agt'] = $this->ruta->get_agt($idz);
                $data['countagt'] = $this->ruta->countart($idz);
                // var_dump($data['blok1']);
                $this->session->set_flashdata("informasi", "<script>swal('Berhasil!','Berhasil Mengganti Data ','success');</script>");
                $this->template->render_page('tambah_ruta3', $data);
            }
            // $this->user_model->tambah_kegiatan();
            // // $this->user_model->tambah_kegiatan2();
            // $this->session->set_flashdata("informasi", "<script>swal('Berhasil!','Berhasil Menambah Kelola Kegiatan','success');</script>");
            // redirect('kelola_kegiatan');
        }
    }
    public function blok8($idz)
    {
        $id = $this->input->post('id', TRUE);
        $catatan = $this->input->post('catatan', TRUE);
        $edit = $this->ruta->ubahblok8($id, $catatan);
        $data['blok1'] = $this->ruta->getrutabyid($idz);
        $data['pengguna'] = $this->db->get_where('dc_pengguna', ['email' => $this->session->userdata('email')])->row_array();

        // var_dump($data['blok1']);
        // $this->template->render_page('tambah_ruta4', $data);
        if ($this->form_validation->run() == false) {
            $edit = $this->ruta->ubahblok8($id, $catatan);
            $data['blok1'] = $this->ruta->getrutabyid($idz);
            $this->session->set_flashdata("informasi", "<script>swal('Gagal!','Mohon isi dengan lengkap','error');</script>");
            $this->template->render_page('tambah_ruta4', $data);
        } else {
            if ($edit) {
                $edit = $this->ruta->ubahblok8($id, $catatan);
                $data['blok1'] = $this->ruta->getrutabyid($idz);
                $this->session->set_flashdata("informasi", "<script>swal('Berhasil!','Berhasil Mengganti Data ','success');</script>");
                $this->template->render_page('tambah_ruta4', $data);
                // redirect('tambah_ruta1');

            }
        }
    }
}
