<?php
defined('BASEPATH') or exit('No direct script access allowed');

class tambah_pengguna extends CI_Controller
{

    public function __construct()
    {
        setlocale(LC_ALL, 'id_ID.utf8');
        parent::__construct();
        $this->load->library('form_validation');
        $this->load->model('Tambah_ruta_model', 'ruta', true);

        is_login();
        // is_admin();
    }
    public function index()
    {
        $data['pengguna'] = $this->db->get_where('dc_pengguna', ['email' => $this->session->userdata('email')])->row_array();
        // var_dump($data['pengguna']);
        $this->template->render_page('tambah_ruta', $data);
    }
    public function tambah()
    {
        $data['pengguna'] = $this->db->get_where('dc_pengguna', ['email' => $this->session->userdata('email')])->row_array();
        $this->form_validation->set_rules('email', 'email', 'required|trim', [
            'required'        => "Email harus diisi"
        ]);
        $this->form_validation->set_rules('username', 'username', 'required|trim', [
            'required'        => "Username harus diisi"
        ]);
        $this->form_validation->set_rules('pass1', 'Kata Sandi', 'required|trim|min_length[6]|matches[pass2]', [
            'required'        => "Kata Sandi harus diisi",
            'matches'         => "Kata Sandi tidak cocok",
            'min_length'        => "Password minimal 6 huruf",
        ]);
        $this->form_validation->set_rules('pass2', 'Password2', 'required|trim', [
            'required'        => "Konfirmasi Kata Sandi harus diisi",
        ]);
        if ($this->form_validation->run() == false) {
            $this->session->set_flashdata("informasi", "<script>swal('Gagal!','Mohon isi dengan lengkap','error');</script>");
            $this->template->render_page('tambah_ruta', $data);
        } else {
            $this->ruta->addpengguna();
            $this->session->set_flashdata("informasi", "<script>swal('Berhasil!','Berhasil Menambah Pengguna','success');</script>");
            redirect('kelola_pengguna');
        }
    }
}
