<?php
defined('BASEPATH') or exit('No direct script access allowed');
/**
 * @property CI_Form_validation $form_validation
 * @property CI_Session $session
 * @property CI_Input $input
 * @property CI_DB $db
 * @property  Ruta_model $ruta
 *@property Template $template
 */
class Kelola_pengguna extends CI_Controller
{

    public function __construct()
    {
        setlocale(LC_ALL, 'id_ID.utf8');
        parent::__construct();
        $this->load->library('form_validation');
        $this->load->model('Tambah_ruta_model', 'ruta', true);

        // $this->load->model('user_model', '', true);

        is_login();
        // is_admin();
    }
    public function index()
    {
        $data['pengguna'] = $this->db->get_where('dc_pengguna', ['email' => $this->session->userdata('email')])->row_array();
        $data['pgn'] = $this->ruta->getpengguna();
        // var_dump($data['ruta']);
        // var_dump($data['ruta']);
        $this->template->render_page('kelola_pengguna', $data);
    }
    public function tambah()

    {
        $data['pgn'] = $this->ruta->getpengguna();
        $data['pengguna'] = $this->db->get_where('dc_pengguna', ['email' => $this->session->userdata('email')])->row_array();
        $this->form_validation->set_rules('email', 'email', 'required|trim', [
            'required'        => "Email harus diisi"
        ]);
        $this->form_validation->set_rules('username', 'username', 'required|trim', [
            'required'        => "Username harus diisi"
        ]);
        $this->form_validation->set_rules('role', 'role', 'required|trim', [
            'required'        => "Role harus diisi"
        ]);
        $this->form_validation->set_rules('status', 'status', 'required|trim', [
            'required'        => "Status harus diisi"
        ]);
        $this->form_validation->set_rules('pass1', 'Kata Sandi', 'required|trim|min_length[6]|matches[pass2]', [
            'required'        => "Kata Sandi harus diisi",
            'matches'         => "Kata Sandi tidak cocok",
            'min_length'        => "Password minimal 6 huruf",
        ]);
        $this->form_validation->set_rules('pass2', 'Password2', 'required|trim', [
            'required'        => "Konfirmasi Kata Sandi harus diisi",
        ]);
        if ($this->form_validation->run() == false) {
            $this->session->set_flashdata("informasi", "<script>swal('Gagal!','Mohon isi dengan lengkap','error');</script>");
            $this->template->render_page('kelola_pengguna', $data);
        } else {
            $this->ruta->addpengguna();
            $this->session->set_flashdata("informasi", "<script>swal('Berhasil!','Berhasil Menambah Pengguna','success');</script>");
            redirect('kelola_pengguna');
        }
    }
    public function getubahpengguna()
    {
        echo json_encode($this->ruta->getpenggunabyid($_POST['idpgn']));
    }
    public function ubahpengguna()
    {
        $id = $this->input->post('id2', TRUE);
        $email2 = $this->input->post('email2', TRUE);
        $role2 = $this->input->post('role2', TRUE);
        $username2 = $this->input->post('username2', TRUE);
        $status2 = $this->input->post('status2', TRUE);


        $edit = $this->ruta->ubahpengguna($id, $role2, $email2, $username2, $status2);
        if ($edit) {
            $this->session->set_flashdata("informasi", "<script>swal('Berhasil!','Berhasil Mengganti Data  Mitra','success');</script>");
            redirect('kelola_pengguna');
        } else {
            $this->session->set_flashdata("informasi", "<script>swal('Gagal!','Tidak Berhasil Mengganti Data  Mitra','error');</script>");
            redirect('kelola_pengguna');
        }
    }
    public function deletepengguna($id)
    {
        if ($this->ruta->hapuspengguna($id) > 0) {
            $this->session->set_flashdata('informasi', "<script>swal('Berhasil!','Berhasil Menghapus Data ','success');</script>");
            redirect('kelola_pengguna');
        } else {
            $this->session->set_flashdata('informasi', "<script>swal('Gagal!','Tidak Berhasil Menghapus Data ','error');</script>");
            redirect('kelola_pengguna');
        }
    }
}
